export async function cmsFetch(path: string) {
  const base = process.env.NEXT_PUBLIC_CMS_URL || "https://cms.yourdomain.com";
  const token = process.env.CMS_API_TOKEN || "";
  const res = await fetch(`${base}${path}`, {
    headers: token ? { Authorization: `Bearer ${token}` } : {},
    cache: "no-store",
  });
  if (!res.ok) return null;
  return res.json();
}
